import 'package:play_lab/constants/method.dart';
import 'package:play_lab/core/utils/url_container.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/model/request/search_request_response_model.dart';
import 'package:play_lab/data/services/api_service.dart';

class RequestRepo {
  ApiClient apiClient;
  RequestRepo({required this.apiClient});

  Future<dynamic> allRequest(String page) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.request}?page=$page';
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<dynamic> myRequest(String page) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.myRequest}?page=$page';
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<dynamic> makeRequest({required SearchItem item, String recommend = ""}) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.makeRequest}';
    Map<String, String> body = {
      "item": item.originalTitle ?? "",
      "track_id": item.id ?? "",
      "recommend": recommend,
      "image_path": item.posterPath ?? "",
      "overview": item.overview ?? "",
    };
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, body, passHeader: true);
    return responseModel;
  }

  Future<dynamic> recentRequest() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.recentRequestItem}';
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<dynamic> searchRequest(String text) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.searchRequestItem}?query=$text';
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<dynamic> voteNSubscribe({bool isVote = true, required Map<String, dynamic> body}) async {
    String url;
    if (isVote) {
      url = '${UrlContainer.baseUrl}${UrlContainer.voteRequest}';
    } else {
      url = '${UrlContainer.baseUrl}${UrlContainer.subscribeRequest}';
    }
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, body, passHeader: true);
    return responseModel;
  }
}
